/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

public class StandardDeviation {
    private int numInitialValues = 20;
    private float averageVal;
    private float totalVal;
    private double runningDelta;
    private int numValues;
    private float[] initVals;
    private boolean ignoreZero;

    public StandardDeviation(int n, boolean bl) {
        this.numInitialValues = n;
        this.initVals = new float[n];
        this.ignoreZero = bl;
    }

    public StandardDeviation(int n) {
        this.numInitialValues = n;
        this.initVals = new float[n];
        this.ignoreZero = true;
    }

    public float getAverage() {
        return this.averageVal;
    }

    public int getNumValues() {
        return this.numValues;
    }

    public float calculate(float f) {
        if (this.ignoreZero && f == 0.0f) {
            if (this.numValues > this.numInitialValues) {
                double d = Math.sqrt(this.runningDelta / (double)(this.numValues - 1));
                return (float)d;
            }
            return Float.NaN;
        }
        ++this.numValues;
        if (this.numValues > this.numInitialValues) {
            this.totalVal += f;
            this.averageVal = this.totalVal / (float)this.numValues;
            float f2 = f - this.averageVal;
            float f3 = f2 * f2;
            this.runningDelta += (double)f3;
            double d = Math.sqrt(this.runningDelta / (double)(this.numValues - 1));
            return (float)d;
        }
        if (this.numValues == this.numInitialValues) {
            this.initVals[this.numValues - 1] = f;
            int n = 0;
            while (n < this.numInitialValues) {
                this.totalVal += this.initVals[n];
                ++n;
            }
            this.averageVal = this.totalVal / (float)this.numValues;
            int n2 = 0;
            while (n2 < this.numInitialValues) {
                float f4 = this.initVals[n2] - this.averageVal;
                float f5 = f4 * f4;
                this.runningDelta += (double)f5;
                ++n2;
            }
            this.initVals = null;
        } else {
            this.initVals[this.numValues - 1] = f;
        }
        return Float.NaN;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("average:");
        stringBuffer.append(this.averageVal);
        stringBuffer.append(" standard deviation:");
        stringBuffer.append(Math.sqrt(this.runningDelta / (double)(this.numValues - 1)));
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        StandardDeviation standardDeviation = new StandardDeviation(20);
        standardDeviation.calculate(5097.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10100.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10101.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10105.0f);
        standardDeviation.calculate(10110.0f);
        standardDeviation.calculate(10120.0f);
        standardDeviation.calculate(10123.0f);
        standardDeviation.calculate(10129.0f);
        standardDeviation.calculate(10120.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10100.0f);
        standardDeviation.calculate(10104.0f);
        standardDeviation.calculate(10105.0f);
        standardDeviation.calculate(10107.0f);
        standardDeviation.calculate(10099.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10097.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(10102.0f);
        standardDeviation.calculate(5097.0f);
    }
}

